-- [ja] ルール
--[[
	基本的にキー操作とサウンドはoverlayのほうで設定 
	現在の状態のやり取りは、getenv("EXFFlag")で取得  
	楽曲情報や必要な変数、画面遷移もすべてoverlayで処理 
	他はあくまで表示内容だけ設定 
--]]
local exsong_inf={};
local exsong_fol={};
local sys_selsong=0;
local sys_seldif={};

local bgs = GetUserPref_Theme("UserBGScale");
if not bgs then
	bgs = 'Fit';
end;
local haishin=GetUserPref_Theme("UserHaishin");
if not haishin then
	haishin="Off";
end;

local t = LoadFallbackB();
local t2 = Def.ActorFrame{
	OnCommand=function(self)
		self:addy(-SCREEN_HEIGHT);
		self:sleep(0.5);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	LoadActor(THEME:GetPathG("_SelectMusic/white","banner"))..{
		InitCommand=function(self)
			self:x(THEME:GetMetric("ScreenSelectMusic","BannerFrameX"));
			self:y(THEME:GetMetric("ScreenSelectMusic","BannerFrameY")-10);
		end;
	};
	LoadActor(THEME:GetPathG("_SelectMusic/white","wheelbg"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(THEME:GetMetric("ScreenSelectMusic","MusicWheelY")-5);
		end;
	};
	LoadActor(THEME:GetPathG("_SelectMusic/white","difficulty"))..{
		PlayerJoinedMessageCommand=cmd(playcommand,"Init");
		InitCommand=function(self)
			self:player(PLAYER_1);
			self:x(THEME:GetMetric("ScreenSelectMusic","MusicWheelX")-130);
			self:y(THEME:GetMetric("ScreenSelectMusic","MusicWheelY")+93);
		end;
	};
	LoadActor(THEME:GetPathG("_SelectMusic/white","difficulty"))..{
		PlayerJoinedMessageCommand=cmd(playcommand,"Init");
		InitCommand=function(self)
			self:player(PLAYER_2);
			self:x(THEME:GetMetric("ScreenSelectMusic","MusicWheelX")+130);
			self:y(THEME:GetMetric("ScreenSelectMusic","MusicWheelY")+93);
		end;
	};
	StandardDecorationFromFileOptional("StageDisplay","StageDisplay");
-- [ja] 以下、EXFolderは特殊な処理のためBannerFrameに記述 
--	StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");
--	StandardDecorationFromFileOptional("SongTime","SongTime");
	StandardDecorationFromFileOptional("BPMLabel","BPMLabel");
	StandardDecorationFromFileOptional("TimeLabel","TimeLabel");
	LoadActor("wheel")..{
		InitCommand=function(self)
			self:x(THEME:GetMetric("ScreenSelectMusic","MusicWheelX"));
			self:y(THEME:GetMetric("ScreenSelectMusic","MusicWheelY"));
			if SCREEN_WIDTH/SCREEN_HEIGHT>1.65 then
				self:zoom(1);
			elseif SCREEN_WIDTH/SCREEN_HEIGHT>1.5 then
				self:zoom(0.9);
			else
				self:zoom(0.8);
			end;
			self:SetDrawByZPosition(true);
			self:zoomz(1);
			self:fov(90);
		end;
	};
	-- Score 
	LoadActor("score")..{
		InitCommand=function(self)
			self:x(THEME:GetMetric("ScreenSelectMusic","BannerFrameX"));
			self:y(SCREEN_BOTTOM-40);
		end;
	};
	LoadActor("diflist")..{
		InitCommand=function(self)
			self:x(THEME:GetMetric("ScreenSelectMusic","BannerFrameX"));
			self:y(SCREEN_BOTTOM-125);
		end;
	};

	StandardDecorationFromFileOptional( "BannerFrame", "BannerFrame" );
	-- GrooveRadar
	StandardDecorationFromFileOptional( "GrooveRadarP1", "GrooveRadarP1" );
	StandardDecorationFromFileOptional( "GrooveRadarP2", "GrooveRadarP2" );

	StandardDecorationFromFileOptional("PaneDisplayTextP1","PaneDisplayTextP1");
	StandardDecorationFromFileOptional("PaneDisplayTextP2","PaneDisplayTextP2");
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","header"))..{
		InitCommand=function(self)
			self:x(SCREEN_LEFT);
			self:y(SCREEN_CENTER_Y-15);
		end;
	};
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","footer"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_BOTTOM);
		end;
	};
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","help"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_BOTTOM-16);
			(cmd(SetSecsBetweenSwitches,4;zoom,0.675;maxwidth,(SCREEN_WIDTH-300)/0.675;shadowlength,1;strokecolor,Color("Black");draworder,105;zoomy,0;zoom,1*0.675;linear,0.175))(self);
		end;
	};
};
t2[#t2+1]= Def.ActorFrame{
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(-SCREEN_HEIGHT);
	end;
-- [ja]決定後のエフェクト 
	Def.Quad{
		InitCommand=cmd(zoomto,SCREEN_WIDTH+1,SCREEN_HEIGHT+1;diffuse,0,0,0,0);
		OffCommand=function(self)
			local song=_SONG();
			if song then
				self:Center();
				self:diffusealpha(0);
				self:addy(-SCREEN_HEIGHT);
				self:sleep(0.55);
				self:decelerate(_TT.S_IN);
				self:addy(SCREEN_HEIGHT);
				self:diffusealpha(1);
			end;
		end;
	};
	Def.Sprite{
		InitCommand=cmd(Center;diffusealpha,0);
		OffCommand=function(self)
			local song;
			if exsong_inf[exsong_fol[sys_selsong].."-Random"]=="" then
				song=_SONG();
			else
				song=GetFolder2Song(getenv("ExGroupName"),exsong_inf[exsong_fol[sys_selsong].."-Random"])
			end;
			if song then
				if song:HasBackground() then
					self:LoadBackground(song:GetBackgroundPath());
				else
					self:Load(THEME:GetPathG("Common","fallback background"));
				end;
				self:zoomtowidth(SCREEN_WIDTH*2);
				self:zoomtoheight(self:GetHeight()*SCREEN_WIDTH/self:GetWidth()*2);
				local ratio=GetSMParameter(song,"bgaspectratio");
				if ratio=="" then ratio="1.333333" end;
				if (bgs == 'Cover' and haishin=="Off") or
					(math.abs(PREFSMAN:GetPreference("DisplayAspectRatio")-tonumber(ratio))<= 0.01 and haishin=="Off") then
					self:scaletocover( 0,0,SCREEN_WIDTH,SCREEN_HEIGHT );
				else
					self:scaletofit( 0,0,SCREEN_WIDTH,SCREEN_HEIGHT );
				end;
				self:diffusealpha(0);
				self:Center();
				self:addy(-SCREEN_HEIGHT);
				self:sleep(0.55);
				self:decelerate(_TT.S_IN);
				self:diffusealpha(PREFSMAN:GetPreference("BGBrightness"));
				self:addy(SCREEN_HEIGHT);
			end;
		end;
	};
};
local sys_selected=false;
local function update(self)
	if getenv("exsong_flag") and getenv("exsong_flag")=="overlay" then
		exsong_inf=getenv("exsong_inf");
		exsong_fol=getenv("exsong_fol");
		setenv("exsong_flag","decorations");
	end;
	if getenv("exsong_chg") then
		sys_selsong=getenv("sys_selsong");
		sys_seldif=getenv("sys_seldif");
		if getenv("diflist_chg") and getenv("score_chg")
			and getenv("pane_chg") and getenv("radar_chg")
			and getenv("banner_chg") and getenv("wheel_chg") then
			setenv("exsong_chg",false);
			setenv("diflist_chg",false);
			setenv("score_chg",false);
			setenv("pane_chg",false);
			setenv("radar_chg",false);
			setenv("banner_chg",false);
			setenv("wheel_chg",false);
		end;
	end;
	if not sys_selected and getenv("sys_selected") then
		sys_selected=true;
		self:queuecommand("Off");
	end;
end;

t2.InitCommand=cmd(SetUpdateFunction,update);
t[#t+1] = t2;
return t;